# Interdisciplinary Lesson Plan Generation

## Definition
- Interdisciplinary lesson plan generation is a curriculum design task. Its core feature is to organically integrate the knowledge, skills, and thinking methods of two or more disciplines around a certain theme, aiming to design a highly integrated and practical teaching plan to cultivate students' comprehensive literacy and ability to solve complex problems.

## Evaluation Framework
- Task Setting:
  - Provide the model with clear prompts, including the core theme, the disciplines expected to be integrated, the target grade level of students, and the expected duration of the course.
  - The model needs to generate a structurally complete and detailed interdisciplinary curriculum design plan within a single round of dialogue.
- Evaluation Data Collection:
  - The complete lesson plan generated by the model will serve as the complete data for evaluation.

## Evaluation Metrics
- The evaluation metrics include five first-level indicators (Theme and Objective Design, Activity and Task Design, Evaluation System Design, Feasibility of Plan Implementation, Logical Structure) and 15 second-level indicators.
  - Each second-level indicator includes: a description of the indicator, positive examples, and negative examples.


<table border="1">
  <tr>
    <td rowspan="1" colspan="2">Evaluation Metric</td>
    <td rowspan="2" colspan="1">Description</td>
    <td rowspan="2" colspan="1">Positive Example</td>
    <td rowspan="2" colspan="1">Negative Example</td>
  </tr>
  <tr>
    <td>First-level Metric</td>
    <td>Second-level Metric</td>
  </tr>
  <tr>
    <td rowspan="3" colspan="1">Theme and Objective Design</td>
    <td>Core Concept Connectivity</td>
    <td>Within a specific theme or knowledge domain, the tightness, clarity, and logical reasonableness of the interconnections between its most important, core concepts. It focuses on whether these core concepts form an organic, structured knowledge network, rather than existing as isolated pieces of information.

</td>
    <td>High Connectivity Example (Theme: Human Digestive System):
When you explain the "human digestive system," you not only list organs like the "mouth, esophagus, stomach, small intestine, large intestine," but you can also clearly explain: Food begins preliminary digestion in the mouth through chewing and enzymes in saliva (like amylase); then it enters the stomach through the esophagus, where stomach acid and pepsin further break down proteins; then it moves to the small intestine, the main site of digestion and absorption, where bile, pancreatic juice, and intestinal juice work together to completely break down fats, carbohydrates, and proteins into small molecules that are absorbed; finally, the unabsorbed residue enters the large intestine to form feces and is excreted.
Here, the concepts of various organs and enzymes are closely linked, forming a complete chain of the digestive process, demonstrating high connectivity.
</td>
    <td>Low Connectivity Example (Theme: Human Digestive System):
You only list organs like the "mouth, stomach, small intestine, large intestine," or describe their functions separately, but you don't explain how they cooperate, how food passes through these organs in sequence, and at which stage various digestive juices play a role. These concepts are independent of each other and do not form a clear process and relationship, resulting in low connectivity.</td>
  </tr>
  <tr>
    <td>Interdisciplinary Logical Integration</td>
    <td>Refers to whether the lesson plan is oriented towards real-world problems and effectively integrates the knowledge, methods, and tools of at least two or more disciplines to jointly solve problems. This integration should be inherent and logical, rather than simply piecing together content from different disciplines.</td>
    <td>High Integration Example (Theme: Environmental Protection):
In a project on "environmental protection," students need to use scientific knowledge (such as ecosystems, pollutants), mathematical skills (such as data statistics, chart analysis), and sociological perspectives (such as environmental policies, community participation) to design a feasible environmental protection plan. Students not only understand the basic concepts of each discipline but can also apply them to solve practical problems, demonstrating high integration.
</td>
    <td>Low Integration Example (Theme: Environmental Protection):
Students learn about pollution types in science, data processing in mathematics, and environmental policies in sociology separately, but this knowledge is not effectively combined. Students may be able to answer questions from each discipline individually, but they cannot connect them to solve practical problems, showing low integration.</td>
  </tr>
  <tr>
    <td>Core Knowledge Coverage</td>
    <td>The extent to which core knowledge points are covered in the teaching process. It focuses on whether the most important and fundamental knowledge of the theme or subject area is covered, rather than scattered, marginal content, and whether it covers three or more basic knowledge points or research methods of the core disciplines.</td>
    <td>High Coverage Example (Theme: Earth Science):
In a course on "Earth Science," students learn about the Earth's structure (such as crust, mantle, core), geological movements (such as plate tectonics, volcanic activity), and climate change (such as the greenhouse effect, global warming). These are all fundamental concepts for understanding Earth science and are covered comprehensively.
</td>
    <td>Low Coverage Example (Theme: Earth Science):
Students only learn about the "crust" or only understand a specific phenomenon (such as a volcanic eruption) without covering other important concepts like climate change or plate tectonics. Such knowledge coverage is relatively one-sided.</td>
  </tr>
  <tr>
    <td rowspan="5" colspan="1">Activity and Task Design</td>
    <td>Cognitive Conflict Design</td>
    <td>Intentionally creating a situation or posing a question in the lesson plan that clearly contradicts or is inconsistent with students' existing experiences, intuitions, common perceptions, or previously learned "common sense" knowledge. This "point of conflict" can be a counter-intuitive experimental phenomenon, a question that challenges common sense, a seemingly contradictory case, or a surprising set of data. Merely creating conflict is not enough; the lesson plan also needs to design a path and method to guide students' inquiry, such as asking guiding questions, providing necessary materials or tools, organizing group discussions, etc. The ultimate goal is to help students resolve this cognitive conflict and form a correct understanding of the relevant concepts or principles.
</td>
    <td>Positive Example
Topic: Junior High Physics "Heat Transfer"
Point of Conflict:
Students intuitively believe that "metal is colder than wood," but the teacher provides thermometer measurements: at room temperature, both the metal block and the wooden block are 25°C.
Inquiry Path:
1. Guiding question: "Is the temperature perceived by touch real?"
2. Group experiment: Use thermometers to measure the surface temperature of different materials.
3. Data analysis: Compare the difference between tactile sensation and actual measurements.
4. Principle explanation: The difference in thermal conductivity leads to a tactile illusion → naturally introduces the concept of "thermal conductivity."
Effect: Overturns intuitive cognition and allows students to independently construct scientific concepts through experiments.
</td>
    <td>Negative Example
Topic: Elementary School Science "Plant Growth"
Situation Design:
The teacher directly asks, "Will seeds sprout in soil?" (Students already have the common knowledge that "they will sprout," no point of conflict) → The activity only requires students to observe the germination process and record it.
Problem Analysis:
No cognitive conflict design (e.g., no introduction of abnormal cases like "Can seeds sprout without light?"), leading to a lack of motivation for inquiry, and students passively accept common knowledge.</td>
  </tr>
  <tr>
    <td>Authenticity of the Context</td>
    <td>Whether the situations or cases designed in the lesson plan are authentic, close to students' life experiences and social reality, and can arouse their interest and resonance. The authenticity of the context can be achieved by using real-world data, cases, problems, etc.</td>
    <td>Positive Example (Authentic and close to life)
Topic: Junior High Mathematics "Data Analysis"
Situation Design:
"The school cafeteria investigated the number of lunch takeout orders from all students and found that over the past week, an average of 527 plastic lunch boxes were generated per day (real school data). If each lunch box weighs 20 grams, please calculate:
The total amount of plastic waste generated by the entire school each month;
Propose solutions to reduce plastic pollution."
Advantage Analysis:
Authenticity: Directly uses takeout data from the students' own school, evoking resonance for environmental protection.
Interest Point: Relates to students' daily behavior (ordering takeout), driving the desire for inquiry.
Social Reality: Extends to garbage classification policies (e.g., new local regulations for 2024).
</td>
    <td>Negative Example (Detached from life experience)
Topic: High School Geography "Water Resource Management"
Situation Design:
"Assume a certain African country has an annual precipitation of 400mm (fictional data) and a population of 20 million. Calculate the per capita water resources and analyze the reasons for water scarcity."
Problem Analysis:
Fictional Data: Does not specify a real country or cite authoritative reports (e.g., UN data).
Detached from Experience: Chinese students lack the life background of Africa and find it difficult to empathize.
Vague Solutions: Asks students to "propose water-saving solutions" but does not connect them to local reality (e.g., community water-saving measures).</td>
  </tr>
  <tr>
    <td>Cognitive Progression Design</td>
    <td>Evaluates whether the interdisciplinary lesson plan systematically guides students to achieve a gradual improvement from basic cognition to advanced thinking skills through carefully designed teaching links.
Cognitive progression design is reflected in the following three key aspects:

"Fact - Concept - Inquiry/Debate" Question Chain:

Consideration: Does the questioning in the lesson plan form a logically graded chain, from memorizing basic facts to understanding core concepts, and finally guiding students to engage in critical thinking, multi-perspective debate, or in-depth inquiry.

"Memory - Comprehension/Analysis - Application/Creation" Task Sequence:

Consideration: Is the learning task in the lesson plan organized in increasing order of cognitive complexity, from requiring students to memorize and recall information, to developing understanding and analysis of information, and finally being able to apply what they have learned to solve problems or create innovative outputs. This usually corresponds to Bloom's Taxonomy of cognitive objectives.

Dynamic Adjustment of Teacher Guidance Strategies with Cognitive Stages:

Consideration: Are the teacher's role and guidance methods flexibly adjusted according to the students' cognitive stage and task requirements.</td>
    <td>Positive Example
Interdisciplinary Lesson Plan (Science + Social Studies):
Question Chain: From fact memorization (global carbon emission data) → concept understanding (greenhouse effect) → dialectical inquiry (policy debate).
Task Sequence: Memorize key terms → analyze impact reports → design emission reduction plans (application/creation).
Teacher Guidance: Direct instruction during the explanation phase → guided discussion during the analysis phase → supervision during the creation phase.
</td>
    <td>Negative Example
Interdisciplinary Lesson Plan (History + Art):
Question Chain: Jumps directly to dialectical debate ("discuss the significance of the Renaissance") → lacks a factual basis (e.g., ignores date data), logical disconnection.
Task Sequence: Only memorizes a list of events → does not advance to analysis or creation, objective not achieved.
Teacher Guidance: Lecturing throughout → no dynamic adjustment, students are passive and do not progress.</td>
  </tr>
  <tr>
    <td>Differentiated Support</td>
    <td>Whether the lesson plan considers individual differences among students and provides support and challenges for learners of different levels and styles. Differentiated support can be reflected in task difficulty, learning resources, evaluation methods, etc.</td>
    <td>High Differentiated Support Example (Theme: Mathematical Application Problem Solving):
The lesson plan designs multi-level tasks: the basic level provides simple application problems, suitable for students with weaker foundations; the intermediate level provides practical problems that require some logical reasoning, suitable for most students; the advanced level provides open-ended questions that require the comprehensive use of various mathematical knowledge, suitable for students with stronger abilities. At the same time, the teacher provides learning resources and tools of different difficulty levels, such as graphing calculators, online simulation software, etc., to meet the needs of different students.
</td>
    <td>Low Differentiated Support Example (Theme: Mathematical Application Problem Solving):
The lesson plan only designs one type of application problem, and all students are required to complete tasks of the same difficulty, without considering the differences between students. This may cause some students to feel that it is too simple and lose interest, while others may feel that it is too difficult and become frustrated.</td>
  </tr>
  <tr>
    <td>Student Engagement</td>
    <td>Whether the lesson plan designs sufficient opportunities for students to actively participate in the learning process, including discussions, cooperation, practice, etc. High engagement usually means that students are active in the classroom rather than passively receiving information.
</td>
    <td>High Engagement Example (Theme: Science Experiment):
The lesson plan designs an experiment project in which students need to work in groups to design the experiment, collect data, and analyze the results. Each group has a clear division of roles, such as experiment leader, recorder, analyst, etc., to ensure that every student can participate in different links. At the same time, the teacher encourages groups to share their experimental results and conduct a class-wide discussion.
</td>
    <td>Low Engagement Example (Theme: Science Experiment):
The lesson plan simply has students watch the teacher demonstrate the experiment process, and students have no opportunity to operate it themselves or participate in discussions. In this case, students' sense of participation is low, and the learning effect may also be affected.</td>
  </tr>
  <tr>
    <td rowspan="3" colspan="1">Evaluation System Design</td>
    <td>Process Reflection Record</td>
    <td>Whether the lesson plan designs reflection sessions or reflective questions for students to record their thoughts, feelings, and learning progress during the learning process. This kind of reflection can help students better understand the content they have learned and promote self-regulated learning.</td>
    <td>High Reflection Record Example (Theme: Historical Event Analysis):
The lesson plan requires students to fill out a reflection journal at the end of each learning unit, recording their understanding of the historical event they have learned, their personal views, and their plans for future learning. The teacher also provides specific guiding reflective questions, such as "What impact do you think this event has on today's society?" and "What challenges did you encounter in your research process?".
</td>
    <td>Low Reflection Record Example (Theme: Historical Event Analysis):
The lesson plan does not have any reflection sessions. Students only complete reading and discussion, and have no opportunity to record their own thoughts and feelings, which may lead to an insufficient understanding of the content they have learned.</td>
  </tr>
  <tr>
    <td>Evaluation Loop Design</td>
    <td>Whether the lesson plan designs a complete evaluation system, including formative evaluation and summative evaluation, to ensure that students receive timely feedback during the learning process and can adjust their learning strategies based on the feedback; the evaluation content should correspond to the teaching objectives.
</td>
    <td>High Evaluation Loop Design Example (Theme: Project-Based Learning):
The lesson plan includes formative evaluations at multiple stages, such as group discussions, phased presentations, peer evaluations, etc., and the teacher provides specific feedback at each stage. In the end, students are also required to submit a comprehensive project report and give an oral presentation, with both the teacher and classmates participating in the evaluation, forming a complete loop.
</td>
    <td>Low Evaluation Loop Design Example (Theme: Project-Based Learning):
The lesson plan only conducts a summative evaluation at the end, without any formative evaluation sessions. Students do not receive timely feedback throughout the learning process, which may prevent them from effectively adjusting their learning strategies.</td>
  </tr>
  <tr>
    <td>Multidimensional Performance Evaluation</td>
    <td>Whether the evaluation methods in the lesson plan are multidimensional, including but not limited to knowledge and skills, interdisciplinary thinking, problem-solving ability, etc., and each evaluation dimension has clear and observable behavioral indicators as evaluation criteria.</td>
    <td>High Multidimensional Performance Evaluation Example:
The evaluation criteria include students' knowledge mastery (such as scientific principles, mathematical calculations), interdisciplinary thinking (such as combining science and sociology to analyze problems), teamwork ability (such as participation in group discussions), etc. Each dimension has specific behavioral performance indicators.
</td>
    <td>Low Multidimensional Performance Evaluation Example:
The lesson plan only focuses on students' knowledge mastery, and the evaluation criteria are limited to the knowledge points of a single discipline, without considering the performance of interdisciplinary thinking or other abilities. In this case, the evaluation dimension is single and cannot fully reflect the students' comprehensive ability.</td>
  </tr>
  <tr>
    <td rowspan="2" colspan="1">Feasibility of Plan Implementation</td>
    <td>Feasibility of Teaching Conditions</td>
    <td>The materials and equipment required for the experimental activities designed in the lesson plan can be found in the school laboratory, the time arrangement is reasonable, and both teachers and students can complete the experiment and conduct discussions within the specified time.</td>
    <td>Positive Example
Chemistry experiment "electrolysis of water," materials (electrodes, beakers) are readily available in the laboratory, time arrangement is 40 minutes for the experiment + 10 minutes for discussion, students can complete and analyze the phenomenon.
</td>
    <td>Negative Example
Physics experiment "superconductivity effect," requires liquid nitrogen equipment that the school does not have, time is only 25 minutes, the experiment is not completed and the discussion is forced to be skipped.</td>
  </tr>
  <tr>
    <td>Adaptability of Materials and Tools</td>
    <td>Whether the materials and tools used in the lesson plan are suitable for the students' age, cognitive level, and learning needs, and whether they can effectively support the achievement of teaching objectives.</td>
    <td>Positive Example
Magnets and paper clips are used in elementary school science class, which are safe and intuitive, and students can easily operate and understand magnetic force.
</td>
    <td>Negative Example
A precision oscilloscope is used in a junior high school physics experiment, which is beyond the cognitive level of the students, making it difficult for them to operate and the objective is not achieved.</td>
  </tr>
  <tr>
    <td rowspan="2" colspan="1">Logical Structure</td>
    <td>Normativeness of the Lesson Plan</td>
    <td>The format is standardized (uniform heading levels/figure and table numbering); whether the language expression of the lesson plan is professional, accurate, and standardized, whether the educational or disciplinary terms used are appropriate, and whether the description is clear, concise, and easy to understand, avoiding ambiguity and redundancy.</td>
    <td>Positive Example
The heading levels of the science lesson plan are uniform (I. Objectives → A. Knowledge), and Figure 1: Cell Structure is clearly labeled. The language is professional: "Students observe the stages of mitosis through a microscope," and the terminology is accurate and concise.
</td>
    <td>Negative Example
The headings are chaotic (no numbered levels), and the figures and tables are not labeled. The language is redundant: "Students will do an experiment to see the wonderful process of cell division," and the terminology is incorrect (e.g., "cell division" is mistaken for "cell splitting"), leading to ambiguity.</td>
  </tr>
  <tr>
    <td>Consistency of Content</td>
    <td>Whether the content of each part of the lesson plan is logically coherent, whether the content is consistent, and whether the teaching objectives, activity design, evaluation methods, etc., correspond to each other to ensure the overall and coherent nature of the teaching process.</td>
    <td>Positive Example
The objective of the biology lesson plan is to "analyze photosynthesis," the activity design is an experiment to observe the changes in chlorophyll, and the evaluation method is an experimental report analyzing the data. The three are logically consistent.
</td>
    <td>Negative Example
The objective is to "master the ecosystem," but the activity is a food chain game, and the evaluation only tests the memory of terms. The disconnection between the parts leads to the failure to achieve the teaching objective.</td>
  </tr>
</table>

## Evaluation Cases
- This evaluation combines 10 different student profiles with core disciplines, main related disciplines, class hour planning, and knowledge mastery to construct 10 evaluation cases, aiming to examine the model's ability to generate interdisciplinary lesson plans.

<table border="1">
  <tr>
    <td>Student Profile</td>
    <td>Core Discipline</td>
    <td>Main Related Discipline</td>
    <td>Class Hour Planning</td>
    <td>Knowledge Mastery</td>
  </tr>
  <tr>
    <td>Grade 7 students (12-13 years old), familiar with the use of basic measuring tools (rulers, graduated cylinders, etc.), have simple observation and recording skills, mainly use visual thinking, and have difficulty understanding abstract concepts.</td>
    <td>Physics</td>
    <td>Mathematics</td>
    <td>4 class hours</td>
    <td>Has mastered the measurement of length and volume, basic concepts of mass and density, and a preliminary understanding of force.</td>
  </tr>
  <tr>
    <td>Grade 9 students, proficient in circuit analysis and Ohm's law, can independently design simple experimental plans, have strong logical reasoning skills, but their ability to comprehensively analyze complex systems needs to be improved.</td>
    <td>Physics</td>
    <td>Chemistry</td>
    <td>3 class hours</td>
    <td>Has mastered the phenomenon of electromagnetic induction, calculation of electric power, and characteristics of series and parallel circuits.</td>
  </tr>
  <tr>
    <td>Grade 7 students (12-13 years old), can perform simple music rhythm analysis, have a basic description of the principles of musical instrument sound production, and lack in-depth thinking when exploring the relationship between physical acoustics and music.</td>
    <td>Physics</td>
    <td>Music</td>
    <td>4 class hours</td>
    <td>Has mastered the generation and propagation of sound, distinction between pitch and loudness, and noise prevention and control.</td>
  </tr>
  <tr>
    <td>Grade 8 students (13-14 years old), good at written expression and information collection, can make simple PPT presentation materials, have some observation of physical phenomena in daily life, but lack in-depth inquiry awareness.</td>
    <td>Physics</td>
    <td>Language Arts</td>
    <td>4 class hours</td>
    <td>Has mastered Newton's first law, pressure calculation, and application of simple machines (inclined planes, wheel and axle).</td>
  </tr>
  <tr>
    <td>Grade 8 students, have a basic foundation in programming, can use geometric tools to draw simple graphics, have a preliminary understanding of data processing, but have weak interdisciplinary integration ability.</td>
    <td>Physics</td>
    <td>Information Technology</td>
    <td>4 class hours</td>
    <td>Has mastered the principles of state changes of matter, characteristics of sound, and laws of reflection and refraction of light.</td>
  </tr>
  <tr>
    <td>Grade 9 students (14-15 years old), familiar with the design process of basic mechanics experiments, can use trigonometric functions to solve simple geometric problems, and have shortcomings in the analysis of multivariable problems.</td>
    <td>Physics</td>
    <td>Mathematics</td>
    <td>3 class hours</td>
    <td>Has mastered the calculation of mechanical efficiency, conversion of work and energy, and composition and resolution of forces.</td>
  </tr>
  <tr>
    <td>Grade 8 students (13-14 years old), have some understanding of topography and landforms in geography, can use maps for positioning, have good spatial imagination, but have a weak ability to combine geographical phenomena with physical principles.</td>
    <td>Physics</td>
    <td>Geography</td>
    <td>4 class hours</td>
    <td>Has mastered the principle of buoyancy, conditions for lever equilibrium, and methods of heat transfer.</td>
  </tr>
  <tr>
    <td>Grade 7 students (12-13 years old), can read simple English popular science articles, have some knowledge of the English names of common physics experiment equipment, and are relatively unfamiliar with expressing physics concepts in English.</td>
    <td>Physics</td>
    <td>English</td>
    <td>3 class hours</td>
    <td>Has mastered the relativity of motion and rest, calculation of speed, and connection of simple circuits.</td>
  </tr>
  <tr>
    <td>Grade 8 students (13-14 years old), familiar with important events in the development of science and technology in history, can analyze the social factors behind the events, and lack a systematic understanding of the role of physics knowledge in the historical process.</td>
    <td>Physics</td>
    <td>History</td>
    <td>4 class hours</td>
    <td>Has mastered friction analysis, application of pulley systems, and examples of energy conversion.</td>
  </tr>
  <tr>
    <td>Grade 8 students (13-14 years old), can use art color principles for simple creation, have a certain aesthetic appreciation for the light and shadow effects of objects, and lack creativity in combining artistic expression with physical optics principles.</td>
    <td>Physics</td>
    <td>Art</td>
    <td>4 class hours</td>
    <td>Has mastered the straight-line propagation of light, laws of plane mirror imaging, and characteristics of lens imaging.</td>
  </tr>
</table> 